//********************************************************************
//Programm: "mit Taste an PD2 soll ein Interrupt ausgeloest werden"
//********************************************************************

#include <avr/io.h>

#include <avr/interrupt.h>

#define F_CPU 8000000UL  	// 8 MHz (fuer delay.h)
#include <util/delay.h>

#include "boarddefs.h" //stellt die Befehle led on/off zur Verfuegung

//********************************************************************

// Interruptserviceroutine
ISR (INT0_vect) {
	_delay_ms(250); //einfach mal eine Weile nix machen     
} 

//********************************************************************

int main(void){

	DDRB = 255; DDRD = 120;            	 // Ausgänge / LEDs
    DDRD &= ~_BV(PD2);PORTD |= _BV(PD2); // PD2 ist Eingang mit Pull Up 
                     		
    PCMSK |= (1<<PIND2); GIMSK  |= (1<<INT0);// Ext. Interrupt an INT0
    MCUCR |=(0<<ISC01) | (0<<ISC00);   		// Interrupt wenn INT0 = GND
    sei();    								// Interrupts erlauben
  

 	
	while (1){
		
		// Lauflicht:
		led1on;  _delay_ms(12); led1off;
		led2on;  _delay_ms(11); led2off;
		led3on;  _delay_ms(10); led3off;
		led4on;  _delay_ms(9); led4off;
		led5on;  _delay_ms(8); led5off;
		led6on;  _delay_ms(7); led6off;
		led7on;  _delay_ms(6); led7off;
		led8on;  _delay_ms(5); led8off;
		led9on;  _delay_ms(4); led9off;
		led10on; _delay_ms(3); led10off;
		led11on; _delay_ms(2); led11off;
		led12on; _delay_ms(1); led12off;
	}


	return 0;
}

//********************************************************************


